 ; Need to modify repall to do only one ssget for each entity type
 ; and then to reuse those sses; this allows changing to a selected
 ; text only mode.
 ; as it is a new ssget is done for each change list, which is not optimal
 ; or obvious when the code is being changed.
 ; Also Repall doesn't do mtext.

 ; Ŀ
 ;   Repall - chgtext for every text entity and attribute in a drawing.    
 ;   A variant of Chall.lsp with no prompts, designed for batch file use.  
 ;   Copyright 1995, 1997, 1998, 2004, 2010 by Rocket Software Ltd.        
 ;   If knowledge is power then why are idiots so dangerous?               
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Multch - change one substring to another in everything.               
 ;   Arguments: CC - the old string                                        
 ;              DD - the new string                                        
 ;              Notouch - the list of block names not to modify            
 ;              LLen - the cycle number/number of replace cycles string    
 ;   Returns a list: number of changes in text, number of text entities    
 ;   changed, number of changes in attributes, number of attributes.       
 ; 
 (DEFUN MULTCH (cc dd notouch llen / ccp chlin chnum rad ss len num changs
                strch enam txt entt altr mods newtxt pa chaags attch esub chg)
  (setq chlin 0)
  (setq chnum 0)
  (setq rad (/ (getvar "viewsize") 45))
  (setq ss (ssget "X" (list (cons 0 "TEXT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Txt " llen)))
  (setq num 0)
  (setq changs 0)
  (setq strch 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq altr (chug cc dd txt))
         (if (> (setq mods (cadr altr)) 0)           ; if any changes made
                (progn
                     (setq newtxt (car altr))
                     (setq changs (+ changs mods))
                     (setq strch (1+ strch))
                     (setq pa (cdr (assoc 10 entt)))
                     (mark pa rad 1)
                     (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))))
  (setq num 0)
  (setq chaags 0)
  (setq attch 0)
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Att")))
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq chg ())
         (while (and (not (member (cdr (assoc 2 (entget enam))) notouch))
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub))))))
                (setq txt (cdr (assoc 1 entt)))
                (setq altr (chug cc dd txt))
                (if (> (setq mods (cadr altr)) 0)        ; if any changes made
                    (progn
                         (setq chg T)
                         (setq newtxt (car altr))
                         (setq chaags (+ chaags mods))
                         (setq attch (1+ attch))
                         (setq pa (cdr (assoc 10 entt)))
                         (mark pa rad 7)
                         (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt))))
                (setq esub (entnext esub)))
         (if chg (entupd enam)))
 (list changs strch chaags attch))
 ; Ŀ
 ;   Multch end.                                                           
 ; 

 ; Ŀ
 ;   Repall - the controller.                                              
 ; 
 (DEFUN C:REPALL (/ picks *error* ccp chlin chnum dd notouch rad hi ss len
                     num changs strch enam txt entt altr mods newtxt pa chaags
                                                             attch esub chg)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   This turns off group selection - otherwise entities in groups may     
 ;   be changed twice with bad things happening as a result.               
 ; 
  (setq picks (getvar "pickstyle"))
  (setvar "pickstyle" 0)
 ; Ŀ
 ;   Something is bound to go wrong.                                       
 ; 
  (defun *error* (shk)
   (setvar "pickstyle" picks)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   This next section is the one to edit.                                 
 ;   The format is ("existing string" "new string"), each line will do     
 ;   one search and replace, in the order they are in here.                
 ;                                                                         
 ;   Watch out for cascades: A to B, B to C, C to D gives all D.           
 ;   C to D, B to C, A to B works properly.                                
 ;   Also 1 to 5, 10 to 20 gives 10 to 50 instead of 10 to 20.             
 ;   10 to 20, 1 to 5 still doesn't work, but 10 to *20*, 1 to 5,          
 ;   and then *20* to 20 can be used if you are careful.                   
 ;   For text the longest common substring should be used - watch for      
 ;   the combination SP to JF which results in SPARE to JFARE.             
 ;   And keep backups, because you can't catch everything.                 
 ; 
  (setq chlist '(("R2T" "R300")
))
 ; Ŀ
 ;   End of search and replace string section.                             
 ; 
  (setq notouch ())
  (setq changs 0)
  (setq strch 0)
  (setq chaags 0)
  (setq attch 0)
  (setq num 0)
  (while (setq sub (nth num chlist))
         (setq num (1+ num))
         (setq llen (strcat (itoa num) "/" (itoa (length chlist))))
         (setq oldstr (car sub))
         (setq newstr (cadr sub))
         (setq chglst (multch oldstr newstr notouch llen))
         (setq changs (+ changs (nth 0 chglst)))
         (setq strch (+ strch (nth 1 chglst)))
         (setq chaags (+ chaags (nth 2 chglst)))
         (setq attch (+ attch (nth 3 chglst))))
  (write-line (strcat (itoa changs) " change" (if (/= changs 1) "s" "") " in "
                      (itoa strch) " text string"  (if (/= strch 1) "s." ".")))
  (write-line (strcat (itoa chaags) " change" (if (/= chaags 1) "s" "") " in "
                      (itoa attch) " attribute" (if (/= attch 1) "s." ".")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))